
## Packages

library(tidyverse)
library(readxl)
library(openxlsx)
library(here)
library(ggplot2)
library(countrycode)
library(lubridate)
library(scales)
library(dplyr)


## Data inputs
data_path <- "data"

#trade data
path_to_IM <- file.path(data_path, "trade data/all_countries_imports.xlsx")
path_to_EX <-file.path(data_path, "trade data/all_countries_exports.xlsx")

#import/export price index - total
IR <- read_excel(file.path(data_path, "price index/IR.xlsx"), sheet = "Monthly")
IQ <- read_excel(file.path(data_path, "price index/IQ.xlsx"), sheet = "Monthly")

#import/export price index - detailed
im_index <- read.delim("data/price index/ei.data.07.LocalityofOrigin", header = TRUE, sep = "\t", stringsAsFactors = FALSE)
ex_index <- read.delim("data/price index/ei.data.08.LocalityofDestination", header = TRUE, sep = "\t", stringsAsFactors = FALSE)
ei_series <- read.delim("data/price index/ei.series", header = TRUE, sep = "\t", stringsAsFactors = FALSE)


## Path to save outputs
path_to_output <- here("output")

## Run the codes in the following order
source("code/01-processing.R")
source("code/02-constructing datasets.R")
source("code/03-price adjustment-updated.R")
source("code/04-export data-updated.R")


